#include <iostream>
#include <vector>
#include <cassert>
#include <cmath>
#include <ctime>
#include <cstdio>
#include <queue>
#include <set>
#include <map>
#include <fstream>
#include <cstdlib>
#include <string>
#include <cstring>
#include <algorithm>
#include <numeric>

#define mp make_pair
#define pb push_back
#define fi first
#define se second
#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()
#define forn(i, n) for (int i = 0; i < (int)(n); ++i)
#define for1(i, n) for (int i = 1; i <= (int)(n); ++i)
#define ford(i, n) for (int i = (int)((n) - 1); i >= 0; --i)
#define fornn(i, a, b) for (int i = (int)(a); i < (int)(b); ++i)
#define fore(i, a, b) for (int i = (int)(a); i <= (int)(b); ++i)
#define debugv(a) forn(i, a.size()) cerr << a[i] << ' '; cerr << '\n'

using namespace std;

typedef pair<int, int> pii;
typedef vector<int> vi;
typedef vector<vi> vvi;

typedef long long i64;
typedef pair<i64, i64> pi64;
typedef vector<i64> vi64;
typedef vector<vi64> vvi64;

typedef long double ld;
typedef vector<ld> vld;
typedef vector<vld> vvld;

int V, MS, MT;
const int MAXN = 50000;
vi e[MAXN];

struct TEdge {
    int from, to, c, w;

    TEdge(int from = 0, int to = 0, int c = 0, int w = 0)
        : from(from)
        , to(to)
        , c(c)
        , w(w)
    {
    }
};

vector<TEdge> es;

void addEdge(int from, int to, int c) {
    e[from].pb(es.size());
    es.pb(TEdge(from, to, c));
    e[to].pb(es.size());
    es.pb(TEdge(to, from, 0));
}

void construct(int D, int N, const vector<pii> &p, int S, int T) {
    es.clear();
    int M = p.size();
    V = (D + 1) * N + D * 2 * M;
    forn(i, V) e[i].clear();
    int Q = 0;
    forn(i, D) {
        forn(j, M) {
            addEdge(Q + p[j].fi, Q + N + j, 1e9);
            addEdge(Q + p[j].se, Q + N + j, 1e9);
        }
        forn(j, M) {
            addEdge(Q + N + j, Q + N + M + j, 1);
            addEdge(Q + N + M + j, Q + N + 2 * M + p[j].fi, 1e9);
            addEdge(Q + N + M + j, Q + N + 2 * M + p[j].se, 1e9);
        }
        forn(k, N) {
            addEdge(Q + k, Q + N + 2 * M + k, 1e9);
        }
        Q += N + 2 * M;
    }
//    V = Q + N;
    MS = S;
    MT = Q + T;
}

bool vis[MAXN];

bool push(int v, int to) {
    if (v == to) return true;
    if (vis[v]) return false;
    vis[v] = true;
    for (int x: e[v]) {
        if (es[x].c < 1) continue;
        if (push(es[x].to, to)) {
            --es[x].c;
            ++es[x].w;
            ++es[x ^ 1].c;
            --es[x ^ 1].w;
            return true;
        }
    }
    return false;
}

vector<pii> ans[200];

bool decomp(int v, int to, vi &path) {
    if (v == to) {
        path.pb(to);
        return true;
    }
    if (vis[v]) return false;
    vis[v] = true;
    for (int x: e[v]) {
        if (es[x].w < 1) continue;
        if (decomp(es[x].to, to, path)) {
            --es[x].w;
            path.pb(v);
            return true;
        }
    }
    return false;
}

int main() {
    ios::sync_with_stdio(false);
#ifdef LOCAL_DEFINE
    freopen("input.txt", "rt", stdin);
//    freopen("output.txt", "wt", stdout);
#endif

    int N, M, K, S, T;
    cin >> N >> M >> K >> S >> T;
    --S; --T;
    vector<pii> edges;
    forn(i, M) {
        int x, y;
        cin >> x >> y;
        --x; --y;
        edges.pb(mp(x, y));
    }
    int L = 0, R = K + N;
    while (R - L > 1) {
        int D = (L + R) / 2;
        construct(D, N, edges, S, T);
        bool ok = true;
        forn(i, K) {
            forn(j, V) vis[j] = false;
            if (!push(MS, MT)) {
                ok = false;
                break;
            }
        }
        if (ok) R = D;
        else L = D;
    }

    construct(R, N, edges, S, T);
    forn(i, K) {
        forn(j, V) vis[j] = false;
        assert(push(MS, MT));
    }
    forn(i, K) {
        forn(j, V) vis[j] = false;
        vi path;
        assert(decomp(MS, MT, path));
        reverse(all(path));
        int j = 0;
        forn(k, R) {
            if (path[j + 1] == path[j] + N + 2 * M) {
                ++j;
                continue;
            }
            ans[k].pb(mp(path[j] - k * (N + 2 * M), path[j + 3] - (k + 1) * (N + 2 * M)));
            if (ans[k].back().fi == ans[k].back().se) ans[k].pop_back();
            j += 3;
        }
    }
    cout << R << '\n';
    forn(i, R) {
        cout << ans[i].size() << "  ";
        for (pii p: ans[i]) cout << p.fi + 1 << ' ' << p.se + 1 << "  ";
        cout << '\n';
    }

#ifdef LOCAL_DEFINE
    cerr << "Time elapsed: " << 1.0 * clock() / CLOCKS_PER_SEC << " s.\n";
#endif
    return 0;
}
